package ru.yandex.crm.apphost.kotlin.handlers.usermanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.UserService
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.GetUserByIdCommand
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UserResponse
import ru.yandex.web.apphost.api.request.RequestContext

class GetUserHandler(
    private val service: UserService
) : AppHostPathHandler {

    override val path = "/user/get"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetUserByIdCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetUserByIdCommand.getDefaultInstance())

        val userId = command.userId
        val user = service.getUser(userId)

        val response = UserResponse.newBuilder()
            .setUser(user)
            .build()
        ctx.addProtobufItem(UserResponse.getDescriptor().getAppHostType(), response)
    }
}
