package ru.yandex.crm.apphost.kotlin.handlers.usermanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.UserService
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.GetUsersListCommand
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UsersResponse
import ru.yandex.web.apphost.api.request.RequestContext

class GetUsersListHandler(
    private val service: UserService
) : AppHostPathHandler {

    override val path = "/user/all"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(GetUsersListCommand.getDescriptor().getAppHostType())
            .getProtobufData(GetUsersListCommand.getDefaultInstance())

        val users = service.getAllUsers()

        val response = UsersResponse.newBuilder()
            .addAllUsers(users)
            .build()
        ctx.addProtobufItem(UsersResponse.getDescriptor().getAppHostType(), response)
    }
}
