package ru.yandex.crm.apphost.kotlin.handlers.usermanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.OrganizationLinkerService
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.RemoveUserFromOrganizationCommand
import ru.yandex.web.apphost.api.request.RequestContext

class RemoveUserFromOrganizationHandler(
    private val service: OrganizationLinkerService
): AppHostPathHandler {

    override val path = "/user/remove-from-organization"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(RemoveUserFromOrganizationCommand.getDescriptor().getAppHostType())
            .getProtobufData(RemoveUserFromOrganizationCommand.getDefaultInstance())
        val organizationId = command.organizationId
        val userId = command.userId

        service.removeUserFromOrganization(userId, organizationId)
    }
}
