package ru.yandex.crm.apphost.kotlin.handlers.usermanager.api

import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.UserService
import ru.yandex.crm.apphost.proto.auditor.Auditor.UpdateEntityAttributeLog
import ru.yandex.crm.apphost.proto.usermanager.Usermanager.UpdateUserCommand
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UserResponse
import ru.yandex.web.apphost.api.request.RequestContext
import kotlin.math.log

class UpdateUserHandler(
    private val service: UserService
) : AppHostPathHandler {

    override val path = "/user/update"

    override fun handle(ctx: RequestContext) {
        val command = ctx.getSingleRequestItem(UpdateUserCommand.getDescriptor().getAppHostType())
            .getProtobufData(UpdateUserCommand.getDefaultInstance())

        val targetUser = command.targetUser
        val userId = command.userId
        val updatedResult = service.updateUser(userId, targetUser)
        val updatedUser = updatedResult.updatedUser
        val logs = updatedResult.logs

        logs.forEach { log ->
            ctx.addProtobufItem(UpdateEntityAttributeLog.getDescriptor().getAppHostType(), log)
        }

        val response = UserResponse.newBuilder()
            .setUser(updatedUser)
            .build()
        ctx.addProtobufItem(UserResponse.getDescriptor().getAppHostType(), response)
    }
}
