package ru.yandex.crm.apphost.kotlin.handlers.usermanager.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.usermanager.OrganizationUser
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.repository.OrganizationUserRepository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository

open class OrganizationUserRepositoryImpl(
    session: Session
) : OrganizationUserRepository, HibernateRepository<OrganizationUser, Long>(session, OrganizationUser::class.java) {
    override fun findAllOrganizationUsers(organizationId: Long): List<OrganizationUser> =
        findAll(
            "from OrganizationUser where organizationId = :organizationId",
            "organizationId" to organizationId
        )

    override fun findOrganizationUsersByPattern(organizationId: Long, pattern: String): List<OrganizationUser> =
        findAll(
            "from OrganizationUser where organizationId = :organizationId " +
                "and lower(concat(user.firstName, ' ', user.lastName)) like :pattern",
            "organizationId" to organizationId,
            "pattern" to "%${pattern.lowercase()}%"
        )

    override fun findOneByOrganizationIdUserId(organizationId: Long, userId: Long): OrganizationUser? =
        findOne(
            "from OrganizationUser where organizationId = :organizationId and user.id = :userId",
            "organizationId" to organizationId,
            "userId" to userId
        )
}
