package ru.yandex.crm.apphost.kotlin.handlers.usermanager.service

import ru.yandex.crm.apphost.proto.auditor.Auditor.UpdateEntityAttributeLog
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UpdateUserData
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.User
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UserData

interface UserService {

    fun getAllUsers(): List<User>

    fun getOrganizationUsers(organizationId: Long, pattern: String? = null): List<User>

    fun getUser(userId: Long): User

    fun createUser(user: UserData): User

    fun updateUser(userId: Long, user: UpdateUserData): UpdateResult

    fun archiveUser(userId: Long): User

    data class UpdateResult(val updatedUser: User, val logs: Collection<UpdateEntityAttributeLog>)
}
