package ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.impl

import ru.yandex.crm.apphost.kotlin.dal.usermanager.OrganizationUser
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.repository.OrganizationUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.repository.UserRepository
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.OrganizationLinkerService
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction

class OrganizationLinkerServiceImpl: OrganizationLinkerService {

    override fun addUserToOrganization(userId: Long, organizationId: Long) {
        transaction {
            val userRepository = getRepository<UserRepository>()
             val organizationUserRepository = getRepository<OrganizationUserRepository>()

            if (organizationUserRepository.findOneByOrganizationIdUserId(organizationId, userId)!=null) {
                return
            }

            val user = userRepository.findOne(userId)
                ?: error("User with id: $userId not found")

            val organizationUser = OrganizationUser(
                organizationId = organizationId,
                user = user,
                isActive = true
            )
            user.organizations.add(organizationUser)

            organizationUserRepository.save(organizationUser)
            userRepository.save(user)
        }
    }

    override fun removeUserFromOrganization(userId: Long, organizationId: Long) {
        transaction {
            val userRepository = getRepository<UserRepository>()
            val organizationUserRepository = getRepository<OrganizationUserRepository>()

            val user = userRepository.findOne(userId)
                ?: error("User with id: $userId not found")

            val organizationUser = organizationUserRepository.findOneByOrganizationIdUserId(organizationId, userId)
                ?: error("User with id: $userId is not in organization with id: $organizationId")

            user.organizations.remove(organizationUser)

            organizationUserRepository.delete(organizationUser)
            userRepository.save(user)
        }
    }
}
