package ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.mappers.impl

import ru.yandex.crm.apphost.kotlin.dal.usermanager.User
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.mappers.ProtoUser
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.mappers.UserEntityMapper
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.UserData

class UserEntityMapperImpl : UserEntityMapper {

    override fun toProtobufModel(user: User): ProtoUser {
        val data = UserData.newBuilder()
            .setFirstName(user.firstName)
            .setSecondName(user.lastName)
            .build()
        return ProtoUser.newBuilder()
            .setUserId(user.id!!)
            .setData(data)
            .build()
    }
}
