package ru.yandex.crm.apphost.kotlin.handlers.usermanager.util

import ru.yandex.crm.apphost.proto.auditor.Auditor.CreateEntityLog
import ru.yandex.crm.apphost.proto.auditor.Auditor.DeleteEntityLog
import ru.yandex.crm.apphost.proto.auditor.Auditor.UpdateEntityAttributeLog
import ru.yandex.crm.proto.gallifrey.usermanager.Usermanager.User

object AuditUtil {

    fun buildCreateUserLog(user: User): CreateEntityLog {
        return CreateEntityLog.newBuilder()
            .setEntityRecordId(user.userId.toString())
            .setOrganizationId(0L)
            .setEntityRecordVersion(1)
            .setEntityMetaId("1")
            .build()
    }

    fun buildDeleteUserLog(user: User): DeleteEntityLog {
        return DeleteEntityLog.newBuilder()
            .setEntityRecordId(user.toString())
            .setEntityMetaId("1")
            .setOrganizationId(0L)
            .setEntityRecordVersion(1)
            .build()
    }

    fun buildUpdateAttributeUserLog(userId: Long, attribute: String, oldValue: String, newValue: String): UpdateEntityAttributeLog {
        return UpdateEntityAttributeLog.newBuilder()
            .setEntityRecordId(userId.toString())
            .setOrganizationId(0L)
            .setEntityMetaId("1")
            .setEntityRecordVersion(1)
            .setAttributeId(attribute)
            .setAttributeNewValue(newValue)
            .setAttributeOldValue(oldValue)
            .build()
    }
}
