package ru.yandex.crm.apphost.kotlin.handlers.usermanager.ut.repository

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.usermanager.OrganizationUser
import ru.yandex.crm.apphost.kotlin.dal.usermanager.User
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.repository.OrganizationUserRepository

class MockOrganizationUserRepository(session: Session) : OrganizationUserRepository {

    private val users = mutableListOf(
        User(id = 1, firstName = "first1", lastName = "last1"),
        User(id = 2, firstName = "first2", lastName = "last2"),
        User(id = 3, firstName = "first3", lastName = "last3"),
        User(id = 4, firstName = "first4", lastName = "last4"),
        User(id = 5, firstName = "first5", lastName = "last5"),
    )

    private val organizationUsers = mutableListOf(
        OrganizationUser(1, 1, users[0]),
        OrganizationUser(2, 2, users[1]),
        OrganizationUser(3, 3, users[2]),
        OrganizationUser(4, 4, users[0]),
        OrganizationUser(5, 5, users[1]),
    )
    override fun findAllOrganizationUsers(organizationId: Long): List<OrganizationUser> =
        organizationUsers.filter { it.organizationId == organizationId }

    override fun findOrganizationUsersByPattern(organizationId: Long, pattern: String): List<OrganizationUser> =
        organizationUsers.filter { it.organizationId == organizationId &&
            (it.user.firstName+' '+it.user.lastName).lowercase().contains(pattern.lowercase())  }

    override fun findOneByOrganizationIdUserId(organizationId: Long, userId: Long): OrganizationUser? =
        organizationUsers.firstOrNull { it.user.id == userId && it.organizationId == organizationId}

    override fun delete(entity: OrganizationUser) {
        TODO("Not yet implemented")
    }

    override fun delete(id: Long) {
        TODO("Not yet implemented")
    }

    override fun findAll(): List<OrganizationUser> {
        TODO("Not yet implemented")
    }

    override fun findAll(queryString: String, vararg params: Pair<String, *>): List<OrganizationUser> {
        TODO("Not yet implemented")
    }

    override fun findOne(id: Long): OrganizationUser? {
        TODO("Not yet implemented")
    }

    override fun findOne(queryString: String, vararg params: Pair<String, *>): OrganizationUser? {
        TODO("Not yet implemented")
    }

    override fun save(entity: OrganizationUser): OrganizationUser {
        TODO("Not yet implemented")
    }
}
