package ru.yandex.crm.apphost.kotlin.handlers.usermanager.ut.repository

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.usermanager.User
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.repository.UserRepository
import kotlin.random.Random

class MockUserRepository(session: Session) : UserRepository(session) {

    private val users = mutableListOf(
        User(id = 1, firstName = "first1", lastName = "last1"),
        User(id = 2, firstName = "first2", lastName = "last2"),
        User(id = 3, firstName = "first3", lastName = "last3"),
        User(id = 4, firstName = "first4", lastName = "last4"),
        User(id = 5, firstName = "first5", lastName = "last5"),
    )

    override fun delete(id: Long) {
        TODO("Not yet implemented")
    }

    override fun findAll(): List<User> {
        return users
    }

    override fun findAll(queryString: String, vararg params: Pair<String, *>): List<User> {
        TODO("Not yet implemented")
    }

    override fun findOne(id: Long): User? {
        return users.find { it.id == id }
    }

    override fun findOne(queryString: String, vararg params: Pair<String, *>): User? {
        TODO("Not yet implemented")
    }

    override fun save(entity: User): User {
        if (entity.id != null) {
            users.removeIf { it.id == entity.id }
            users.add(entity)
            return entity
        }
        entity.id = Random.nextLong()
        users.add(entity)
        return entity
    }
}
