package ru.yandex.crm.apphost.kotlin.handlers.usermanager.ut.service.mapper

import org.junit.jupiter.api.BeforeEach
import org.junit.jupiter.api.Test
import org.koin.test.KoinTest
import ru.yandex.crm.apphost.kotlin.dal.usermanager.User
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.mappers.UserEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.service.mappers.impl.UserEntityMapperImpl
import kotlin.properties.Delegates
import kotlin.test.assertEquals

class UserEntityMapperTests : KoinTest {

    private var mapper: UserEntityMapper by Delegates.notNull()

    @BeforeEach
    fun beforeEach() {
        mapper = UserEntityMapperImpl()
    }

    @Test
    fun `map entity to protobuf model`() {
        val entity = User(
            id = 1,
            firstName = "first name",
            lastName = "last name"
        )

        val protoModel = mapper.toProtobufModel(entity)

        assertEquals(1L, protoModel.userId)
        assertEquals("first name", protoModel.data.firstName)
        assertEquals("last name", protoModel.data.secondName)
    }
}
