package ru.yandex.crm.apphost.kotlin.handlers.userselector

import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.schema.OrganizationManagerSchema
import ru.yandex.crm.apphost.kotlin.dal.usermanager.schema.UserManagerSchema
import ru.yandex.crm.apphost.kotlin.handlers.userselector.api.UserSelectorService
import ru.yandex.crm.apphost.kotlin.handlers.userselector.repository.OrganizationRepository
import ru.yandex.crm.apphost.kotlin.handlers.userselector.repository.UserRepository
import ru.yandex.crm.apphost.kotlin.handlers.userselector.repository.impl.DefaultOrganizationRepository
import ru.yandex.crm.apphost.kotlin.handlers.userselector.repository.impl.DefaultUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.userselector.service.AuthenticateService
import ru.yandex.crm.apphost.kotlin.handlers.userselector.service.impl.AuthenticateServiceImpl
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSchema
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.web.apphost.api.grpc.AppHostTypedServant

fun HostBuilder.withUserSelectorModule() = withModule(module {

    factory { params -> DefaultUserRepository(params.get()) } bind UserRepository::class
    factory { params -> DefaultOrganizationRepository(params.get())} bind OrganizationRepository::class

    single { UserManagerSchema() } bind HibernateSchema::class
    single { OrganizationManagerSchema() } bind HibernateSchema::class

    single { AuthenticateServiceImpl() } bind AuthenticateService::class

    single { UserSelectorService(get()) } bind AppHostTypedServant::class
})
