package ru.yandex.crm.apphost.kotlin.handlers.userselector.api

import ru.yandex.crm.apphost.kotlin.handlers.userselector.service.AuthenticateService
import ru.yandex.crm.apphost.proto.userselector.UserSelector.AuthenticateRequest
import ru.yandex.crm.apphost.proto.userselector.UserSelector.AuthenticateResponse
import ru.yandex.crm.apphost.proto.userselector.UserSelector.YandexService
import ru.yandex.crm.apphost.proto.userselector.UserSelector.YandexUser
import ru.yandex.crm.apphost.proto.userselector.UserSelectorServiceBase
import ru.yandex.web.apphost.api.request.RequestMeta

class UserSelectorService(
    private val authService: AuthenticateService
): UserSelectorServiceBase() {

    override fun authenticate(requestMeta: RequestMeta, requestBody: AuthenticateRequest): AuthenticateResponse {
        val yandexUser: YandexUser? = if (requestBody.hasUser()) {
            requestBody.user
        } else { null }
        val yandexService: YandexService? = if (requestBody.hasService()) {
            requestBody.service
        } else { null }

        val result = authService.processAuthenticate(yandexUser, yandexService)

        val response = AuthenticateResponse.newBuilder()
        if (result != null) {
            val user = result.user
            val organizations = result.organizations

            response.user = user
            response.addAllOrganizations(organizations)
        }
        return response.build()
    }
}
