package ru.yandex.crm.apphost.kotlin.handlers.userselector.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import ru.yandex.crm.apphost.kotlin.handlers.userselector.repository.OrganizationRepository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository

class DefaultOrganizationRepository(
    session: Session
) : HibernateRepository<Organization, Long>(session, Organization::class.java), OrganizationRepository {

    override fun getAllOrganizationsWithUserId(userId: Long): List<Organization> {
        val queryString = "SELECT organizationmanager.organization FROM organizationmanager.organization " +
            "INNER JOIN usermanager.organization_user " +
            "ON (organization_user.user_id = :userId AND organization.id = organization_user.organization_id)"
        val query = session.createNativeQuery(queryString, Organization::class.java)
        query.setParameter("userId", userId)
        return query.resultList?.map { it as Organization } ?: emptyList()
    }
}
