package ru.yandex.crm.apphost.kotlin.handlers.userselector.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.dal.usermanager.User
import ru.yandex.crm.apphost.kotlin.handlers.userselector.repository.UserRepository
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import javax.persistence.NoResultException

class DefaultUserRepository(
    session: Session
) : HibernateRepository<User, Long>(session, User::class.java), UserRepository {

    override fun getUserWithUID(uid: Long): User? {
        val queryString = "SELECT usermanager.user FROM usermanager.user " +
            "INNER JOIN usermanager.yandex_user " +
            "ON (yandex_user.uid = :uid AND yandex_user.user_id = usermanager.user.user_id) LIMIT 1"
        val query = session.createNativeQuery(queryString, User::class.java)
        query.setParameter("uid", uid)
        return try {
            query.singleResult as? User
        } catch (ex: NoResultException) {
            null
        }
    }

    override fun getUserWithTvmId(tvmId: Long): User? {
        val queryString = "SELECT usermanager.user FROM usermanager.user " +
            "INNER JOIN usermanager.yandex_service " +
            "ON (yandex_service.tvm_id = :tvmId AND yandex_service.user_id = usermanager.user.user_id) LIMIT 1"
        val query = session.createNativeQuery(queryString, User::class.java)
        query.setParameter("tvmId", tvmId)
        return try {
            query.singleResult as? User
        } catch (ex: NoResultException) {
            null
        }
    }
}
