package ru.yandex.crm.apphost.kotlin.handlers.userselector.service.impl

import ru.yandex.crm.apphost.kotlin.handlers.userselector.service.AuthenticateService
import ru.yandex.crm.apphost.kotlin.handlers.userselector.service.models.AuthenticateResult
import ru.yandex.crm.apphost.proto.userselector.UserSelector.Organization
import ru.yandex.crm.apphost.proto.userselector.UserSelector.User
import ru.yandex.crm.apphost.proto.userselector.UserSelector.User.AuthenticationType
import ru.yandex.crm.apphost.proto.userselector.UserSelector.YandexService
import ru.yandex.crm.apphost.proto.userselector.UserSelector.YandexUser

class MockAuthenticateService : AuthenticateService {

    override fun processAuthenticate(
        yandexUser: YandexUser?,
        yandexService: YandexService?
    ): AuthenticateResult? {
        if (yandexUser != null) {
            val user = processYandexUserAuth(yandexUser)
            val organization = getOrganization()
            return AuthenticateResult(user, listOf(organization))
        }
        if (yandexService != null) {
            val user = processYandexServiceAuth(yandexService)
            val organization = getOrganization()
            return AuthenticateResult(user, listOf(organization))
        }

        return null
    }

    private fun getOrganization(): Organization {
        return Organization.newBuilder()
            .setOrganizationId(1)
            .setPoolId(1)
            .build()
    }

    private fun processYandexUserAuth(yandexUser: YandexUser): User {
        return User.newBuilder()
            .setUserId(1)
            .setAuthenticationType(AuthenticationType.YaStaffUser)
            .build()
    }

    private fun processYandexServiceAuth(yandexService: YandexService): User {
        return User.newBuilder()
            .setUserId(2)
            .setAuthenticationType(AuthenticationType.YaService)
            .build()
    }
}
