package ru.yandex.crm.apphost.kotlin.handlers.whoami

import NAppHostHttp.Http.THttpResponse
import mu.KotlinLogging
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.apphost.PROTO_HTTP_RESPONSE
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.proto.userselector.UserSelector.Organization
import ru.yandex.crm.apphost.proto.userselector.UserSelector.User
import ru.yandex.crm.apphost.proto.whoami.Whoami.Response
import ru.yandex.web.apphost.api.request.RequestContext

class HttpPresenterHandler : AppHostPathHandler {

    override val path = "/response/whoami"

    override fun handle(ctx: RequestContext) {
        val user = ctx.getSingleRequestItem(User.getDescriptor().getAppHostType())
            .getProtobufData(User.getDefaultInstance())
        val organizations = ctx.getRequestItems(Organization.getDescriptor().getAppHostType())
            .map { it.getProtobufData(Organization.getDefaultInstance()) }

        val response = Response.newBuilder()
            .addAllOrganization(organizations)
            .setUser(user)
            .build()
        val httpResponse = THttpResponse.newBuilder()
            .setContent(response.toByteString())
            .build()
        ctx.addProtobufItem(PROTO_HTTP_RESPONSE, httpResponse)

        logger.info("Path: $path Message: User with id: ${user.userId} and Organizations(${organizations.size}) added to context as PROTO_HTTP_RESPONSE")
    }

    companion object {

        private val logger = KotlinLogging.logger { }
    }
}
