package ru.yandex.crm.apphost.kotlin.services.entitymanager

import kotlinx.coroutines.runBlocking
import ru.yandex.crm.apphost.kotlin.common.apphost.withAppHost
import ru.yandex.crm.apphost.kotlin.handlers.aggregator.withAggregatorModule
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.withEntityManagerModule
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.config.withEntityStorageModule
import ru.yandex.crm.apphost.kotlin.handlers.monolithstorage.withMonolithStorageModule
import ru.yandex.crm.library.kotlin.database.hibernate.withHibernate
import ru.yandex.crm.library.kotlin.database.jooq.withJooq
import ru.yandex.crm.library.kotlin.database.withDatabase
import ru.yandex.crm.library.kotlin.service.CrmHost
import ru.yandex.crm.library.kotlin.service.web.withDefaultWebService

fun main(args: Array<String>) = runBlocking {
    CrmHost
        .createDefaultBuilder(args)
        .withDefaultWebService()
        .withAppHost()
        .withDatabase()
        .withHibernate()
        .withJooq()
        .withAggregatorModule()
        .withEntityStorageModule()
        .withEntityManagerModule()
        .withMonolithStorageModule()
        .build()
        .run()
}
