package ru.yandex.crm.apphost.kotlin.services.thematrix

import kotlinx.coroutines.runBlocking
import ru.yandex.crm.apphost.kotlin.common.apphost.withAppHost
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.withDepartmentManager
import ru.yandex.crm.apphost.kotlin.handlers.organizationmanager.withOrganizationModule
import ru.yandex.crm.apphost.kotlin.handlers.teammanager.withTeamManagerModule
import ru.yandex.crm.apphost.kotlin.handlers.usermanager.withUserManager
import ru.yandex.crm.library.kotlin.database.hibernate.withHibernate
import ru.yandex.crm.library.kotlin.database.withDatabase
import ru.yandex.crm.library.kotlin.service.CrmHost
import ru.yandex.crm.library.kotlin.service.web.withDefaultWebService

fun main(args: Array<String>) = runBlocking {
    CrmHost
        .createDefaultBuilder(args)
        .withDefaultWebService()
        .withAppHost()
        .withDatabase()
        .withHibernate()
        .withDepartmentManager()
        .withOrganizationModule()
        .withTeamManagerModule()
        .withUserManager()
        .build()
        .run()
}
