package ru.yandex.crm.apphost.kotlin.services.userselector

import kotlinx.coroutines.runBlocking
import ru.yandex.crm.apphost.kotlin.common.apphost.withAppHost
import ru.yandex.crm.apphost.kotlin.handlers.userselector.withUserSelectorModule
import ru.yandex.crm.apphost.kotlin.handlers.whoami.withWhoAmIModule
import ru.yandex.crm.library.kotlin.database.hibernate.withHibernate
import ru.yandex.crm.library.kotlin.database.withDatabase
import ru.yandex.crm.library.kotlin.service.CrmHost
import ru.yandex.crm.library.kotlin.service.web.withDefaultWebService

fun main(args: Array<String>) = runBlocking {
    CrmHost
        .createDefaultBuilder(args)
        .withDefaultWebService()
        .withAppHost()
        .withDatabase()
        .withHibernate()
        .withUserSelectorModule()
        .withWhoAmIModule()
        .build()
        .run()
}
