package ru.yandex.crm.apphost.kotlin.tools.timelineentitygenerator

import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager.CreateEntityRecordData
import java.util.*

class FloydMessageGenerator : EntityRecordGeneratorBase() {
    private val attributes = listOf(
        EntityAttributeSchema("sender") { UUID.randomUUID().toString() },
        EntityAttributeSchema("chat_id") { UUID.randomUUID().toString() },
        EntityAttributeSchema("text") { "text: ${getRandomString(200)}" }
    )

    fun generate(ticketId: String, departmentId: UUID): CreateEntityRecordData {
        val entityAttributes = mutableListOf(EntityAttributeSchema("tickets") { ticketId })
        entityAttributes.addAll(attributes)
        return super.generate(departmentId, entityAttributes)
    }
}
