package ru.yandex.crm.apphost.kotlin.tools.timelineentitygenerator

import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager.CreateEntityRecordData
import java.time.LocalDate
import java.util.*
import kotlin.random.Random

class TicketGenerator : EntityRecordGeneratorBase() {
    private val attributes = listOf(
        EntityAttributeSchema("Line") { Random.nextInt(0, 2000000).toString() },
        EntityAttributeSchema("deadline_date") { LocalDate.now().plusDays(Random.nextLong(100)).toString() },
        EntityAttributeSchema("floyd_message") { "test" }
    )

    fun generate(accountId: String, departmentId: UUID): CreateEntityRecordData {
        val entityAttributes = mutableListOf(EntityAttributeSchema("account") { accountId })
        entityAttributes.addAll(attributes)
        return super.generate(departmentId, entityAttributes)
    }
}
