const { execSync } = require('child_process');
const fs = require('fs');

const myArgs = process.argv.slice(2).reduce((acc, item) => {
    const [key, value] = item.split('=');
    acc[key] = value;
    return acc;
}, {});

const { version, stage, bucketPath } = myArgs;

if (!version) {
    throw new Error(`the version cannot be empty`);
}
if (!stage) {
    throw new Error(`the stage cannot be empty`);
}

const STAGE_NAME = 'crm-frontend-apphost';
const configYaml = execSync(`ya tool dctl get stage ${STAGE_NAME}`).toString();

const mdsEnvRegexp = new RegExp(
    `^((.|\n)*?(${stage}\:)(.|\n)*?MDS_STATIC_BUILD_PATH(.|\n)+?literal_env(.|\n)+?value:)(.+)((.|\n)*)$`,
);
const matchMdsEnv = configYaml.match(mdsEnvRegexp);

if (!matchMdsEnv) {
    throw new Error('can not find env var for change');
}

const newConfig =
    matchMdsEnv[1] +
    ` s3://crm-frontend/${bucketPath}/${version}` +
    matchMdsEnv[8];

fs.writeFileSync('./config.patch.yaml', newConfig);

execSync('ya tool dctl --version');
execSync('ya tool dctl put stage ./config.patch.yaml');
