const createDevConfig = require('../webpack/webpack.dev');
const path = require('path');

module.exports = {
    core: {
        builder: '@storybook/builder-webpack5',
    },
    framework: '@storybook/react',
    stories: ['../stories/**/*.stories.mdx', '../stories/**/*.stories.tsx'],
    addons: ['@storybook/addon-links', '@storybook/addon-essentials'],
    webpackFinal: config => {
        const devConfig = createDevConfig({
            distPath: path.join(__dirname, '../dist'),
        });

        const mdxRule = config.module.rules.find(
            rule =>
                rule.test instanceof RegExp &&
                rule.test.test('file.stories.mdx'),
        );

        return {
            ...config,
            module: {
                ...config.module,
                ...devConfig.module,
                rules: [...devConfig.module.rules, mdxRule],
            },
            resolve: {
                ...config.resolve,
                modules: [
                    ...config.resolve.modules,
                    ...devConfig.resolve.modules,
                ],
            },
            devServer: devConfig.devServer,
        };
    },
};
