import React, { FC, useCallback, useState } from 'react';
import {
    DepartmentsTree,
    OnDepartmentSelect,
} from 'components/DepartmentsTree';
import { MenuPanel } from './MenuPanel';
import { AttributesPanel } from './AttributesPanel';
import { AdminPageProps } from './AdminPage.types';

export const AdminPage: FC<AdminPageProps> = props => {
    const { organizationId } = props;

    const [currentDepartmentId, setCurrentDepartmentId] = useState<
        string | null
    >(null);

    const handleDepartmentSelect = useCallback<OnDepartmentSelect>(
        department => {
            setCurrentDepartmentId(department.id);
        },
        [],
    );

    return (
        <>
            <MenuPanel />
            {organizationId != null && (
                <DepartmentsTree
                    organizationId={organizationId}
                    onDepartmentSelect={handleDepartmentSelect}
                />
            )}
            {organizationId != null && (
                <AttributesPanel
                    organizationId={organizationId}
                    departmentId={currentDepartmentId}
                />
            )}
        </>
    );
};
