import React, { FC } from 'react';
import { ComponentsProperty } from '@crm/components/dist/AttributesByScheme';
import Spin from '@crm/components/dist/lego2/Spin';
import { Text } from '@crm/components/dist/lego2/Text';
import { useQuery } from '@apollo/client';
import { AttributesByScheme } from 'components/AttributesByScheme';
import { AttributesProps } from './Attributes.types';
import {
    GetDepartmentUsersQuery,
    GetDepartmentUsersQueryResponse,
    GetDepartmentUsersQueryVariables,
} from './GetDepartmentUsers.query';
import css from './Attributes.module.css';

export const Attributes: FC<AttributesProps> = props => {
    const { organizationId, departmentId } = props;

    const { loading, data } = useQuery<
        GetDepartmentUsersQueryResponse,
        GetDepartmentUsersQueryVariables
    >(GetDepartmentUsersQuery, {
        variables: {
            organizationId,
            departmentId,
        },
    });
    const department = data?.organization.department;

    const components: ComponentsProperty = {
        StaffSuggestMultiple: {
            getProps: () => ({
                isDisabled: true,
                value: department?.users,
            }),
        },
    };

    return (
        <div className={css.Attributes}>
            {Array.isArray(department?.names) && (
                <div className={css.Attributes__nameWrap}>
                    <Text typography="body-long-m" weight="medium">
                        {department?.names[0].name}
                    </Text>
                </div>
            )}
            {loading ? (
                <Spin view="default" size="m" position="center" progress />
            ) : (
                <AttributesByScheme
                    components={components}
                    scheme={[
                        {
                            name: 'members',
                            label: 'Сотрудники',
                            component: 'StaffSuggestMultiple',
                        },
                    ]}
                />
            )}
        </div>
    );
};
