import { gql } from '@apollo/client';
import { Department } from 'types/Department';
import { User } from 'types/User';

export const GetDepartmentUsersQuery = gql`
    query GetDepartmentsUsers($organizationId: Int!, $departmentId: String!) {
        organization(id: $organizationId) {
            department(id: $departmentId) {
                names {
                    languageCode
                    name
                }
                users {
                    id
                    firstName
                    lastName
                }
            }
        }
    }
`;

export type GetDepartmentUsersQueryUser = Pick<
    User,
    'id' | 'firstName' | 'lastName'
>;

export interface GetDepartmentUsersQueryVariables {
    organizationId: number;
    departmentId: string;
}

export interface GetDepartmentUsersQueryResponse {
    organization: {
        department: Pick<Department, 'names'> & {
            users: GetDepartmentUsersQueryUser[];
        };
    };
}
