import React, { FC, useState } from 'react';
import { Panel, Position, Tone } from '@crm/components/dist/Panel';
import { Attributes } from './Attributes';
import { AttributesPanelProps } from './AttributesPanel.types';
import css from './AttributesPanel.module.css';

export const AttributesPanel: FC<AttributesPanelProps> = props => {
    const { organizationId, departmentId } = props;
    const [panelId, setPanelId] = useState('');

    return (
        <Panel
            wrapClassName={css.AttributesPanel}
            panelId={panelId}
            tone={Tone.White}
            position={Position.Right}
            hasPinButton={false}
            isNewDesign
            name="attributes"
            pin={false}
            size={{ width: 300 }}
            setPanelId={id => setPanelId(id as string)}
            panels={[
                {
                    id: 'attributes',
                    title: 'Атрибуты',
                    content: departmentId != null && (
                        <Attributes
                            organizationId={organizationId}
                            departmentId={departmentId}
                        />
                    ),
                    padding: false,
                },
            ]}
        />
    );
};
