import React, { FC, useState } from 'react';
import { Panel, Position, Tone } from '@crm/components/dist/Panel';

export const MenuPanel: FC = () => {
    const [panelId, setPanelId] = useState('');

    return (
        <Panel
            panelId={panelId}
            tone={Tone.Superlight}
            position={Position.Left}
            hasPinButton={false}
            isNewDesign
            name="menu"
            pin={false}
            size={{ width: 300 }}
            setPanelId={id => setPanelId(id as string)}
            panels={[
                {
                    id: 'menu',
                    title: 'Навигация',
                    content: <>Content</>,
                },
            ]}
        />
    );
};
