import React, { FC } from 'react';
import { BubbleProps } from '@crm/components/dist/Bubble';
import { PopupItemUser } from 'components/PopupItemUser';
import { UserBubble } from 'components/UserBubble';
import { SuggestSelectMultiple } from '@crm/components/dist/Attribute2/SuggestSelectMultiple';
import { Text } from '@crm/components/dist/lego2/Text';
import { User } from 'types/User';
import { StaffSuggestMultipleProps } from './StaffSuggestMultiple.types';

const userFullName = (user: User) => `${user.lastName} ${user.firstName}`;
const userAdapter = (user: User) => ({
    ...user,
    name: userFullName(user),
});
const getKey = (user: User) => user.id;
const renderReadingRow = (user: User) => (
    <Text typography="control-m">{userFullName(user)}</Text>
);
const renderSelectedBubble = (user: User, props: BubbleProps) => (
    <UserBubble {...props} user={userAdapter(user)} />
);
const renderPopupItem = (user: User) => (
    <PopupItemUser user={userAdapter(user)} />
);

export const StaffSuggestMultiple: FC<StaffSuggestMultipleProps> = props => {
    return (
        <SuggestSelectMultiple<User>
            {...props}
            getKey={getKey}
            renderReadingRow={renderReadingRow}
            renderSelectedBubble={renderSelectedBubble}
            renderPopupItem={renderPopupItem}
        />
    );
};
