import React, { FC } from 'react';
import {
    AttributesByScheme as AttributesBySchemeComponent,
    AttributesBySchemeProps,
    ComponentsProperty,
} from '@crm/components/dist/AttributesByScheme';
import { StaffSuggestMultiple } from './StaffSuggestMultiple';

export const AttributesByScheme: FC<AttributesBySchemeProps> = props => {
    const components: ComponentsProperty = {
        ...props.components,
        StaffSuggestMultiple: {
            render: StaffSuggestMultiple,
            ...props.components?.StaffSuggestMultiple,
        },
    };

    return <AttributesBySchemeComponent {...props} components={components} />;
};
