import React, { FC, useCallback, useState } from 'react';
import { StaffSuggestMultiple as StaffSuggestMultipleComponent } from 'components/Attribute';
import { AttributeComponentProps } from '@crm/components/dist/AttributesByScheme';
import {
    StaffSuggestMultipleEditingValue,
    StaffSuggestMultipleProps,
} from 'components/Attribute/StaffSuggestMultiple/StaffSuggestMultiple.types';

export const StaffSuggestMultiple: FC<
    AttributeComponentProps & {
        onLoad?: StaffSuggestMultipleProps['onLoad'];
    }
> = props => {
    const { attribute, onChange, isDisabled, onLoad } = props;
    const value = (props.value as StaffSuggestMultipleEditingValue) || [];
    const [isReadingLoading, setReadingLoading] = useState(false);
    const [isEditing, setEditing] = useState(false);

    const handleChange = useCallback(
        async (newValue: StaffSuggestMultipleEditingValue) => {
            setReadingLoading(true);
            try {
                await onChange(attribute, newValue || null);
            } finally {
                setReadingLoading(false);
            }
        },
        [onChange],
    );

    return (
        <StaffSuggestMultipleComponent
            label={attribute.label}
            name={attribute.name}
            isEditing={isEditing}
            onEditingChange={setEditing}
            readingValue={value}
            editingValue={value}
            isReadingLoading={isReadingLoading}
            isDisabled={isDisabled}
            onChange={handleChange}
            onLoad={onLoad}
        />
    );
};
