import { gql } from '@apollo/client';

export const ChangeDepartmentParentMutation = gql`
    mutation ChangeDepartmentParent(
        $organizationId: Int!
        $departmentId: String!
        $parentDepartmentId: String!
    ) {
        updateDepartment(
            organizationId: $organizationId
            departmentId: $departmentId
            input: { parentDepartmentId: $parentDepartmentId }
        ) {
            id
            organizationId
            parentDepartmentId
            names {
                languageCode
                name
            }
        }
    }
`;

export interface ChangeDepartmentParentMutationVariables {
    organizationId?: number;
    departmentId?: string;
    parentDepartmentId?: string;
}
