import { gql } from '@apollo/client';

export const CreateChildDepartmentMutation = gql`
    mutation CreateChildDepartment(
        $organizationId: Int!
        $parentDepartmentId: String!
        $name: String!
    ) {
        createDepartment(
            input: {
                organizationId: $organizationId
                parentDepartmentId: $parentDepartmentId
                names: [{ languageCode: "ru", name: $name }]
            }
        ) {
            id
        }
    }
`;

export interface CreateChildDepartmentMutationVariables {
    organizationId?: number;
    name?: string;
    parentDepartmentId?: string;
}
