import React, { FC } from 'react';
import { Popup } from 'components/Popup';
import { TreeNode } from 'components/TreeNode';
import { useContext, useEffect, useRef, useState } from 'react';
import { context } from '../DepartmentsTree.context';
import css from './DepartmentNode.module.css';
import { DepartmentNodeProps } from './DepartmentNode.types';

export const DepartmentNode: FC<DepartmentNodeProps> = props => {
    const { node } = props;

    const name = `${node?.names[0]?.name} ${node.id}` || '';
    const callbacks = useContext(context);
    const [visible, setVisible] = useState(false);
    const buttonRef = useRef<HTMLButtonElement>(null);
    const popupRef = useRef<HTMLElement>();

    useEffect(() => {
        const handleMouseDown = (event: MouseEvent) => {
            if (
                !event
                    .composedPath()
                    .find(
                        element =>
                            element === buttonRef.current ||
                            element === popupRef.current,
                    )
            ) {
                setVisible(false);
            }
        };

        document.addEventListener('mousedown', handleMouseDown);
        return () => {
            document.removeEventListener('mousedown', handleMouseDown);
        };
    });

    return (
        <TreeNode
            className={css.DepartmentNode}
            title={name}
            appendAddon={
                <div className={css.DepartmentNode__addon}>
                    {node.usersCount != null && (
                        <span className={css.DepartmentNode__usersCount}>
                            {node.usersCount}
                        </span>
                    )}
                    <button
                        className={css.DepartmentNode__actions}
                        onClick={() => setVisible(prev => !prev)}
                        ref={buttonRef}
                    >
                        ...
                    </button>

                    <Popup
                        className={css.DepartmentNode__popup}
                        visible={visible}
                        innerRef={instance => (popupRef.current = instance)}
                    >
                        <button
                            onClick={() => {
                                callbacks.startChangeDepartmentParent(node.id);
                            }}
                        >
                            Переместить
                        </button>
                        <button
                            onClick={() =>
                                callbacks.startRenameDepartment(node.id)
                            }
                        >
                            Переименовать
                        </button>
                        <button
                            onClick={() => {
                                callbacks.startAddChildDepartment(node.id);
                            }}
                        >
                            Добавить департамент
                        </button>
                        <button
                            onClick={() => {
                                callbacks.archiveDepartment(node.id);
                            }}
                        >
                            Архивировать
                        </button>
                    </Popup>
                </div>
            }
        />
    );
};
