import { Tree } from 'types/Tree';
import { TreeDataNode } from './DepartmentsTree.types';
import { GetOrganizationDepartmentsQueryDepartment } from './GetOrganizationDepartments.query';

export const treeToData = (
    tree: Tree<string, GetOrganizationDepartmentsQueryDepartment>,
    ids = tree.root,
): TreeDataNode[] => {
    return ids.map(id => {
        const node = tree.nodes[id];
        const result: TreeDataNode = {
            ...node,
            key: id,
        };
        if (tree.children[id]) {
            result.children = treeToData(tree, tree.children[id]);
        }
        return result;
    });
};

export const departmentsToTreeData = (
    departments: GetOrganizationDepartmentsQueryDepartment[],
): TreeDataNode[] => {
    const tree: Tree<string, GetOrganizationDepartmentsQueryDepartment> = {
        root: [],
        children: {},
        nodes: {},
    };
    for (let i = 0; i < departments.length; i++) {
        const department = departments[i];
        tree.nodes[department.id] = department;
        if (
            !department.parentDepartmentId ||
            department.parentDepartmentId === 'null'
        ) {
            tree.root.push(department.id);
        } else {
            if (!tree.children[department.parentDepartmentId]) {
                tree.children[department.parentDepartmentId] = [];
            }
            tree.children[department.parentDepartmentId].push(department.id);
        }
    }

    return treeToData(tree);
};
