import { gql } from '@apollo/client';
import { Department } from 'types/Department';

export const GetOrganizationDepartmentsQuery = gql`
    query GetOrganizationDepartments($organizationId: Int!) {
        organization(id: $organizationId) {
            departments {
                id
                organizationId
                parentDepartmentId
                names {
                    languageCode
                    name
                }
                usersCount
            }
        }
    }
`;

export type GetOrganizationDepartmentsQueryDepartment = Pick<
    Department,
    'id' | 'organizationId' | 'parentDepartmentId' | 'names' | 'usersCount'
>;

export interface GetOrganizationDepartmentsQueryVariables {
    organizationId: number;
}

export interface GetOrganizationDepartmentsQueryResponse {
    organization: {
        departments: GetOrganizationDepartmentsQueryDepartment[];
    };
}
