import { gql } from '@apollo/client';

export const RenameDepartmentMutation = gql`
    mutation RenameDepartment(
        $organizationId: Int!
        $departmentId: String!
        $name: String!
    ) {
        updateDepartment(
            organizationId: $organizationId
            departmentId: $departmentId
            input: { names: [{ languageCode: "ru", name: $name }] }
        ) {
            id
            organizationId
            parentDepartmentId
            names {
                languageCode
                name
            }
        }
    }
`;

export interface RenameDepartmentMutationVariables {
    organizationId?: number;
    departmentId?: string;
    name?: string;
}
