import React, { FC } from 'react';
import cx from 'classnames';
import { PopupProps } from './Popup.types';
import css from './Popup.module.css';

export const Popup: FC<PopupProps> = props => {
    const { visible, children, innerRef } = props;

    const className = cx(props.className, css.Popup);

    return (
        <>
            {visible && (
                <div className={className} ref={innerRef}>
                    {children}
                </div>
            )}
        </>
    );
};
