import React, { useEffect } from 'react';
import { HashRouter, Route, Routes } from 'react-router-dom';
import {
    ApolloClient,
    InMemoryCache,
    ApolloProvider,
    createHttpLink,
} from '@apollo/client';
import { getCookie } from 'utils/getCookie';
import { configureRootTheme } from '@yandex-lego/components/Theme';
import { crmMgLightTheme } from '@crm/components/dist/lego2/Theme/presets/themes';
import { DepartmentsTreeRoute } from 'components/DepartmentsTree/DepartmentsTree.route';
import { AdminPageRoute } from 'components/AdminPage';
import './Root.css';

const link = createHttpLink({
    uri: '/graphql',
    credentials: 'same-origin',
    headers: {
        'x-csrf-token': getCookie('x-csrf-token')!,
    },
});

const client = new ApolloClient({
    cache: new InMemoryCache({
        typePolicies: {
            DepartmentName: {
                merge: true,
            },
        },
    }),
    link,
});

export const Root: React.FC = () => {
    useEffect(() => {
        configureRootTheme({ theme: crmMgLightTheme });
    }, []);

    return (
        <ApolloProvider client={client}>
            <HashRouter>
                <Routes>
                    <Route
                        path=":organizationId"
                        element={<DepartmentsTreeRoute />}
                    />
                    <Route path="admin" element={<AdminPageRoute />} />
                </Routes>
            </HashRouter>
        </ApolloProvider>
    );
};
