import React, { FC } from 'react';
import cx from 'classnames';
import { TreeNodeProps } from './TreeNode.types';
import css from './TreeNode.module.css';

export const TreeNode: FC<TreeNodeProps> = props => {
    const { title, appendAddon } = props;

    const className = cx(css.TreeNode, props.className);

    return (
        <div className={className}>
            <span>{title}</span>
            {appendAddon}
        </div>
    );
};
