import React, { FC, useRef } from 'react';
import { useFocus } from '@crm/components/dist/useFocus';
import { Bubble } from '@crm/components/dist/Bubble';
import { UserBubbleProps } from './UserBubble.types';

export const UserBubble: FC<UserBubbleProps> = props => {
    const { user, ...restProps } = props;

    const bubbleRef = useRef<HTMLElement>();
    const isFocused = useFocus(bubbleRef);

    return (
        // @ts-ignore
        <Bubble
            {...restProps}
            enableFocusStyles={false}
            innerRef={instance => (bubbleRef.current = instance)}
            view={isFocused ? 'default' : 'clear'}
        >
            {user.name}
        </Bubble>
    );
};
