import React from 'react';
import { useQuery } from '@apollo/client';
import { Tree } from 'components/Tree';
import { UserListItem } from 'components/UserListItem';
import { USERS_QUERY } from './UserList.constants';
import { UserListResponse } from './UserList.types';

export const UserList: React.FC = () => {
    const { loading, error, data } = useQuery<UserListResponse>(USERS_QUERY);

    if (loading) return <div>Loading...</div>;
    if (error) return <div>Error : {String(error)}</div>;
    if (!data?.users) return <div>No Users</div>;

    const treeData = data.users.map(user => ({ key: user.id, user }));

    return (
        <Tree treeData={treeData} titleRender={UserListItem} showIcon={false} />
    );
};
