const path = require('path');
const HtmlWebpackPlugin = require('html-webpack-plugin');

module.exports = ({ distPath, publicPath }) => {
    return {
        entry: path.resolve(__dirname, '../src/index.tsx'),
        resolve: {
            modules: [path.resolve(__dirname, '../src'), 'node_modules'],
            extensions: ['.ts', '.tsx', '.js', '.jsx', '.css'],
        },
        module: {
            rules: [
                {
                    test: /\.(ts|js)x?$/,
                    exclude: /node_modules/,
                    use: [
                        {
                            loader: 'babel-loader',
                        },
                    ],
                },
                {
                    test: /\.module.css$/,
                    use: [
                        'style-loader',
                        {
                            loader: 'css-loader',
                            options: {
                                modules: true,
                            },
                        },
                    ],
                },
                {
                    test: /\.css$/,
                    exclude: /\.module.css$/,
                    use: ['style-loader', 'css-loader'],
                },
                {
                    test: /\.react\.svg$/,
                    use: [
                        {
                            loader: 'babel-loader',
                        },
                        {
                            loader: 'svg-sprite-loader',
                            options: {
                                symbolId: '[name].[hash:base64:5]',
                                runtimeGenerator: require.resolve(
                                    './svg-to-icon-component-runtime-generator',
                                ),
                                runtimeOptions: {
                                    iconModule: './webpack/icon.tsx',
                                },
                            },
                        },
                        {
                            loader: 'svgo-loader',
                        },
                    ],
                },
                {
                    test: /\.(ttf|eot|woff|woff2|wav|mp3)/,
                    exclude: /\.(inline|react)\.svg$/,
                    type: 'asset/resource',
                    generator: {
                        filename: '[path][name][ext]',
                    },
                },
            ],
        },
        output: {
            path: distPath,
            publicPath,
        },
        mode: process.env.NODE_ENV,
        plugins: [
            new HtmlWebpackPlugin({
                template: path.resolve(__dirname, '../src/template.html'),
                publicPath: publicPath ? publicPath : 'auto',
            }),
        ],
    };
};
