const path = require('path');

const webpackDev = require('./webpack.dev');
const webpackProd = require('./webpack.prod');

const DIST_PATH = path.join(__dirname, '../dist');

module.exports = env => {
    const NODE_ENV = process.env.NODE_ENV;

    let distPath = DIST_PATH;

    if (NODE_ENV === 'production') {
        const APP_VERSION = env.fullversion || 'DEV';
        distPath = path.join(distPath, APP_VERSION);

        return webpackProd({ distPath, publicPath: env.publicPath });
    }

    return webpackDev({ distPath });
};
