const { merge } = require('webpack-merge');
const ReactRefreshWebpackPlugin = require('@pmmmwh/react-refresh-webpack-plugin');
const webpackCommon = require('./webpack.common');

const devConfig = () => {
    return {
        mode: 'development',
        devtool: 'cheap-module-source-map',
        output: {
            filename: 'bundle.[name].js',
        },
        devServer: {
            server: {
                type: 'https',
            },
            client: {
                overlay: false,
            },
            host: 'localhost.yandex-team.ru',
            port: 8080,
            proxy: [
                {
                    context: ['**'],
                    headers: {
                        'Access-Control-Allow-Origin': '*',
                    },
                    target: 'https://hamster.crm.apphost.in.yandex-team.ru',
                    secure: false,
                    changeOrigin: true,
                },
            ],
        },
        plugins: [new ReactRefreshWebpackPlugin()],
    };
};

module.exports = args => merge(webpackCommon(args), devConfig(args));
