import { AsyncLocalStorage } from 'async_hooks';
import { injectable, inject } from 'inversify';
import { TYPES } from './typings/TYPES';
import { BaseMiddleware } from './BaseMiddleware';
import { NextFunction } from './typings/NextFunction';
import { AsyncLocalStorageStore } from './typings/AsyncLocalStorageStore';
import { BaseContext } from './typings/BaseContext';

@injectable()
export class AsyncLocalStorageMiddleware<
    Context extends BaseContext,
> extends BaseMiddleware<Context> {
    constructor(
        @inject(TYPES.AsyncLocalStorage)
        private asyncLocalStorage: AsyncLocalStorage<AsyncLocalStorageStore>,
    ) {
        super();
    }

    public async handler(ctx: Context, next: NextFunction) {
        await this.asyncLocalStorage.run(new Map(), async () => {
            await next();
        });
    }
}
