import { injectable, interfaces as inversifyInterfaces } from 'inversify';
import { RequestContext } from './typings/RequestContext';
import { BaseContext } from './typings/BaseContext';
import { NextFunction } from './typings/NextFunction';

@injectable()
export abstract class BaseMiddleware<Context extends BaseContext> {
    // httpContext is initialized when the middleware is invoked
    // see resolveMidleware in server.ts for more details
    public requestContext!: RequestContext<Context>;

    protected bind<T>(
        serviceIdentifier: inversifyInterfaces.ServiceIdentifier<T>,
    ): inversifyInterfaces.BindingToSyntax<T> {
        return this.requestContext.container.bind(serviceIdentifier);
    }

    public abstract handler(ctx: Context, next: NextFunction): Promise<void>;
}

export interface BaseMiddlewareConstuctor<Context extends BaseContext> {
    new (...args: never[]): BaseMiddleware<Context>;
}
