import { AsyncLocalStorage } from 'async_hooks';
import { inject, injectable } from 'inversify';
import { NAppHostProtocol } from '@crm/protos';
import { BaseContext } from './typings/BaseContext';
import { NextFunction } from './typings/NextFunction';
import { TYPES } from './typings/TYPES';
import { BaseMiddleware } from './BaseMiddleware';
import { AsyncLocalStorageStore } from './typings/AsyncLocalStorageStore';

@injectable()
export class ParseRequestMiddleware<
    Context extends BaseContext,
> extends BaseMiddleware<Context> {
    public constructor(
        @inject(TYPES.AsyncLocalStorage)
        private asyncLocalStorage: AsyncLocalStorage<AsyncLocalStorageStore>,
    ) {
        super();
    }

    public async handler(ctx: Context, next: NextFunction) {
        const request = NAppHostProtocol.TServiceRequest.decode(
            ctx.getRawRequestData(),
        );
        this.bind<NAppHostProtocol.TServiceRequest>(
            TYPES.Request,
        ).toConstantValue(request);

        const store = this.asyncLocalStorage.getStore();
        store?.set('reqid', request.RequestInfo?.Reqid || undefined);

        await next();
    }
}
